using System;
using System.IO;
using DynaPDF;

namespace examples
{
	class Class1
	{
      /*
         Note that the dynapdf.dll must be copied into the output directory or into a
         Windwos search path (e.g. %WINDOWS%/System32) before the application can be executed!
      */

      // Error callback function.
      // If the function name should not appear at the beginning of the error message then set
      // the flag emNoFuncNames (pdf.SetErrorMode(DynaPDF.TErrMode.emNoFuncNames);).
      static int PDFError(IntPtr Data, int ErrCode, IntPtr ErrMessage, int ErrType)
      {
         Console.Write("{0}\n", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage));
         return 0; // We try to continue if an error occurrs. Any other return value breaks processing.
      }

		[STAThread]
		static void Main(string[] args)
		{
         try
         {
            int gs, img;
            TPDFExtGState g;
            CPDF pdf = new CPDF();
            // Error messages and warnings are passed to the callback function.
            pdf.SetOnErrorProc(IntPtr.Zero, new DynaPDF.TErrorProc(PDFError));
            pdf.CreateNewPDF(null); // We open the output file later if no error occurrs.

            // Disable color key masking for images
            pdf.SetUseTransparency(false);

            pdf.SetPageCoords(TPageCoord.pcTopDown);

            pdf.Append();

               pdf.SetFont("Helvetica", TFStyle.fsRegular, 12.0, false, TCodepage.cp1252);
               pdf.WriteText(50.0, 50.0, "Fill Alpha = 0.5");

               pdf.Rectangle(50.0, 70.0, 110.0, 160.0, TPathFillMode.fmFill);
               pdf.SetFillColor(CPDF.PDF_WHITE);
               pdf.WriteText(55.0, 75.0, "Background");

               g = new TPDFExtGState();
               pdf.InitExtGState(ref g);
               g.FillAlpha = 0.5f;
               gs = pdf.CreateExtGState(ref g);
               pdf.SetExtGState(gs);

               img = pdf.InsertImageEx(60.0, 84.0, 200.0, 0.0, "../../../../test_files/images/tree-frog-69813_640.jpg", 0);

               // To restore an extended graphics state, create a second one that restores the changes made before and activate this state.
               g.FillAlpha = 1.0f;
               gs = pdf.CreateExtGState(ref g);
               pdf.SetExtGState(gs);

               pdf.SetFillColor(CPDF.PDF_BLACK);
               pdf.WriteText(340.0, 50.0, "Fill Alpha = 1.0 (default)");
               pdf.Rectangle(340.0, 70.0, 110.0, 160.0, TPathFillMode.fmFill);
               pdf.SetFillColor(CPDF.PDF_WHITE);
               pdf.WriteText(345.0, 75.0, "Background");
               pdf.PlaceImage(img, 350.0, 84.0, 200.0, 0.0);

            pdf.EndPage();

            // No fatal error occurred?
            if (pdf.HaveOpenDoc())
            {
               // We write the output file into the current directory.
               String filePath = Directory.GetCurrentDirectory() + "\\out.pdf";
               // OK, now we can open the output file.
               if (!pdf.OpenOutputFile(filePath)) return;
               if (pdf.CloseFile())
               {
                  Console.Write("PDF file \"{0}\" successfully created!\n", filePath);
                  System.Diagnostics.Process p = new System.Diagnostics.Process();
                  p.StartInfo.FileName = filePath;
                  p.Start();
               }
            }
            pdf = null;
         }catch(Exception e)
         {
            Console.Write(e.Message);
            Console.Read();
         }
		}
	}
}
